function dX = PDE_Time(t,X,D,light,DU_1,DU_2,DU_3,DU_4)

%State vector, X: 1 to N is [AHL], N+1 to 2N is [CI]
%for [AHL], dx = D*X + f(X)
%for [CI], dx = f(X)
N = length(D);

P_light = ( (-9/10) .* light ./ 255 + 1);
AHL = X(1:N);
CI = X(N+1:2*N);

dX(1:N) = D*AHL + DU_1 .* P_light - DU_3.*AHL; 
dX(N+1:2*N) = DU_2 .* P_light - DU_4*CI;

dX=dX';

%Steady-state solution is: 
%AHL = -DU_1 .* P_light * (D - I*DU_3)^-1
%CI = (DU_2 / DU_4) .* P_light 

return